#!/usr/bin/python

## User Options ######################################################
#Cull characters from GEDCOM file (does not apply to .csv files)
cull_loners = True
cull_childless_spouses = False

#Create .csv files
create_dynasty_csv = True
create_character_csv = True
create_family_csv = True

## Initialization ####################################################
#Debugging Toggles
debugging1 = False
debugging2 = False
debugging3 = False

if create_dynasty_csv or create_character_csv or create_family_csv:
  create_csv = True
else:
  create_csv = False

#Constants
digits = ['0','1','2','3','4','5','6','7','8','9']
month_name = ['JAN','FEB','MAR','APR','MAY','JUN','JUL','AUG','SEP','OCT','NOV','DEC']

#Data Objects
dynasty_list = []
class dynasty(object):
  """Stores information relevant to a dynasty."""
  pass

character_list = []
class character(object):
  """Stores information relevant to a character."""
  def __init__(self):
    self.id = [] #Game ID
    self.birth_name = ''
    self.gender = 1
    self.birth_year = []
    self.birth_month = []
    self.birth_day = []
    self.death_year = []
    self.death_month = []
    self.death_day = []
    self.father = ''
    self.mother = ''
    self.spouse = []
    self.dynasty_id = []
    self.dynasty_name = ''
    self.loner = True
    self.GEDCOM_id = ''
    self.FAMS = []
    self.FAMC = ''

#Helper Functions
def state_change(new_state, announce):
  if announce: print new_state
  return new_state

## Get Information from User #########################################
savefilename = raw_input('Enter the name of the save file without extension: ')

## Opening 'dynasties.txt' ###########################################
print '### Now reading dynasties.txt ###'
try:
  with open('dynasties.txt','rb') as file:
    
    bracket_count = 0
    state = 'dynasties_default'
    temp_string = ''
    file_contents = file.read()
    
    for x in file_contents:
      if x is '{':
        bracket_count += 1
      elif x is '}':
        bracket_count -= 1
      
      if state is 'dynasties_default':
        if bracket_count is 0 and x in digits:
          state = state_change('dynasties_id', debugging1)
          temp_string += x
      elif state is 'dynasties_id':
        if x in digits:
          temp_string += x
        else:
          dynasty_id = int(temp_string)
          dynasty_list.append(dynasty())
          dynasty_list[-1].id = dynasty_id
          state = state_change('dynasties_name_1', debugging1)
          temp_string = ''
      elif state is 'dynasties_name_1':
        temp_string += x
        if 'name' in temp_string:
          state = state_change('dynasties_name_2', debugging1)
          temp_string = ''
      elif state is 'dynasties_name_2':
        if x is '"':
          state = state_change('dynasties_name_3', debugging1)
      elif state is 'dynasties_name_3':
        if x is not '"':
          temp_string += x
        else:
          dynasty_list[-1].name = temp_string
          state = state_change('dynasties_default', debugging1)
          temp_string = ''
   
    file.close()

except:
  print ''
  print ' ################################'
  print ' # Error reading dynasties.txt. #'
  print ' ################################'
  print ''
  raise

## Opening the Save File #############################################
print '### Finished reading dynasties.txt. Now reading .ck2 file. ###'
try:
  with open(savefilename+'.ck2','rb') as file:
  
    bracket_count = 0
    state = 'save_default'
    count = 0
    temp_string = ''
    file_contents = file.read()
    has_run = False
    
    for x in file_contents:
      count += 1
      if x is '{':
        bracket_count += 1
      elif x is '}':
        bracket_count -= 1
        add_dynasty = 0
      


      #Default state
      if state is 'save_default':
        if bracket_count is 0:
          temp_string += x
        else:
          temp_string = ''
        if 'dynasties' in temp_string:
          state = state_change('dynasties_default', debugging2)
          has_run = False
          temp_string = ''
        elif 'character' in temp_string:
          state = state_change('character_default', debugging2)
          has_run = False
          temp_string = ''
        elif 'delayed_event' in temp_string:
          'here'
          break
      #Dynasties state
      elif state is 'dynasties_default':
        if bracket_count is 1 and x in digits:
          has_run = True
          state = state_change('dynasties_id', debugging2)
          temp_string += x
        elif bracket_count is 0 and has_run:
          state = state_change('save_default', debugging2)
          temp_string = ''
      elif state is 'dynasties_id':
        if x in digits:
          temp_string += x
        else:
	  add_dynasty = int(temp_string) 
          state = state_change('dynasties_name_1', debugging2)
          temp_string = ''
      elif state is 'dynasties_name_1':
        temp_string += x
        if 'name' in temp_string:
          state = state_change('dynasties_name_2', debugging2)
          temp_string = ''
	elif '}' in temp_string:
		state = state_change('dynasties_name_4', debugging2)
          	temp_string = ''
      elif state is 'dynasties_name_2':
        if x is '"':
          state = state_change('dynasties_name_3', debugging2)
      elif state is 'dynasties_name_3':
        if x is not '"':
          temp_string += x
        else:
          dynasty_list.append(dynasty())
          dynasty_list[-1].id = dynasty_id
          dynasty_list[-1].name = temp_string
          state = state_change('dynasties_default', debugging2)
          temp_string = ''
	  add_dynasty = 0
      elif state is 'dynasties_name_4':
          state = state_change('dynasties_default', debugging2)
          temp_string = ''
      #Character state
      elif state is 'character_default':
        if bracket_count is 1 and x in digits:
          has_run = True
          state = state_change('character_id', debugging3)
          temp_string += x
        elif bracket_count is 0 and has_run:
          state = state_change('save_default', debugging3)
          temp_string = ''
      elif state is 'character_id':
        if x in digits:
          temp_string += x
        else:
          character_id = int(temp_string)
          character_list.append(character())
          character_list[-1].id = character_id
          state = state_change('character_data', debugging3)
          has_run2 = False
          substate = 'default'
          temp_string = ''
      elif state is 'character_data':
        if substate is 'default':
          if bracket_count is 2:
            has_run2 = True
            temp_string += x
          elif bracket_count is 1 and has_run2:
            state = state_change('character_default', debugging3)
            temp_string = ''
          if 'birth_name' in temp_string:
            substate = state_change('birth_name', debugging3)
            getting_name = False
            temp_string = ''
          if 'female' in temp_string:
            character_list[-1].gender = 0
            temp_string = ''
          if 'birth_date' in temp_string:
            substate = state_change('birth_date', debugging3)
            getting_date = 0
            temp_string = ''
          if 'death_date' in temp_string:
            substate = state_change('death_date', debugging3)
            getting_date = 0
            temp_string = ''
          if 'father' in temp_string:
            substate = state_change('father', debugging3)
            getting_id = False
            temp_string = ''
          if 'mother' in temp_string:
            substate = state_change('mother', debugging3)
            getting_id = False
            temp_string = ''
          if 'spouse' in temp_string:
            substate = state_change('spouse', debugging3)
            getting_id = False
            temp_string = ''
          if 'dynasty' in temp_string:
            substate = state_change('dynasty', debugging3)
            getting_id = False
            temp_string = ''
        elif substate is 'birth_name':
          if getting_name is False and x is '"':
            getting_name = True
          elif getting_name is True and x is not '"':
            temp_string += x
          elif getting_name is True and x is '"':
            character_list[-1].birth_name = temp_string
            substate = state_change('default', debugging3)
            temp_string = ''
        elif substate is 'birth_date':
          if getting_date is 0 and x is '"':
            getting_date = 1
          elif getting_date is 1 and x is not '.':
            temp_string +=  x
          elif getting_date is 1 and x is '.':
            character_list[-1].birth_year = int(temp_string)
            getting_date = 2
            temp_string = ''
          elif getting_date is 2 and x is not '.':
            temp_string += x
          elif getting_date is 2 and x is '.':
            character_list[-1].birth_month = int(temp_string)
            getting_date = 3
            temp_string = ''
          elif getting_date is 3 and x is not '"':
            temp_string += x
          elif getting_date is 3 and x is '"':
            character_list[-1].birth_day = int(temp_string)
            substate = state_change('default', debugging3)
            temp_string = ''
        elif substate is 'death_date':
          if getting_date is 0 and x is '"':
            getting_date = 1
          elif getting_date is 1 and x is not '.':
            temp_string +=  x
          elif getting_date is 1 and x is '.':
            character_list[-1].death_year = int(temp_string)
            getting_date = 2
            temp_string = ''
          elif getting_date is 2 and x is not '.':
            temp_string += x
          elif getting_date is 2 and x is '.':
            character_list[-1].death_month = int(temp_string)
            getting_date = 3
            temp_string = ''
          elif getting_date is 3 and x is not '"':
            temp_string += x
          elif getting_date is 3 and x is '"':
            character_list[-1].death_day = int(temp_string)
            substate = state_change('default', debugging3)
            temp_string = ''
        elif substate is 'father':
          if x in digits:
            temp_string += x
            getting_id = True
          elif getting_id is True:
            character_list[-1].father = int(temp_string)
            substate = state_change('default', debugging3)
            temp_string = ''
        elif substate is 'mother':
          if x in digits:
            temp_string += x
            getting_id = True
          elif getting_id is False:
            if x is ' ' or x is '=':
              pass
            else:
              substate = state_change('default', debugging3)
              temp_string = ''
          elif getting_id is True:
            character_list[-1].mother = int(temp_string)
            substate = state_change('default', debugging3)
            temp_string = ''
        elif substate is 'spouse':
          if x in digits:
            temp_string += x
            getting_id = True
          elif getting_id is True:
            character_list[-1].spouse.append(int(temp_string))
            substate = state_change('default', debugging3)
            temp_string = ''
        elif substate is 'dynasty':
          if x in digits:
            temp_string += x
            getting_id = True
          elif getting_id is True:
            character_list[-1].dynasty_id = int(temp_string)
            substate = state_change('default', debugging3)
            temp_string = ''
	  elif bracket_count is 1:
		substate = state_change('default', debugging3)
    
    file.close()
except:
  print ''
  print ' #######################'
  print ' # Error reading file. #'
  print ' #######################'
  print ''
  raise

## Processing the Save File ##########################################
print '### Finished reading .ck2 file. Now processing data. ###'
#Find a dynasty in the list based on its id#.
dynasty_map = {}
for i_dynasty in dynasty_list:
  dynasty_map[i_dynasty.id] = i_dynasty

#Find a character in the list based on its id#.
character_map = {}
for i_character in character_list:
  character_map[i_character.id] = i_character

#Assign dynasty names to characters.
for i_character in character_map:
  c_character = character_map[i_character]
  if c_character.dynasty_id in dynasty_map:
    print (c_character.dynasty_id)
    c_character.dynasty_name = dynasty_map[c_character.dynasty_id].name

#Create families.
family_list = []
family_map = {}
family_id = 1
class family(object):
  """Stores information relevant to a family (GEDCOM definition)."""
  def __init__(self):
    self.id = ''
    self.father = []
    self.mother = []
    self.children = []

for i_character in character_map:
  c_character = character_map[i_character]
  #If the character has a parent or spouse, place it into a family.
  if type(c_character.father) is int or type(c_character.mother) is int:
    c_character.loner = False
    temp = (c_character.father, c_character.mother)
    if temp not in family_map:
      family_list.append(family())
      c_family = family_list[-1]
      c_family.id = family_id
      c_family.father = c_character.father
      c_family.mother = c_character.mother
      c_family.children.append(c_character.id)
      family_map[temp] = c_family
      if type(c_family.father) is int:
        character_map[c_family.father].FAMS.append(c_family.id)
        character_map[c_family.father].loner = False
      if type(c_family.mother) is int:
        character_map[c_family.mother].FAMS.append(c_family.id)
        character_map[c_family.mother].loner = False
      c_character.FAMC = c_family.id
      family_id += 1
    else:
      c_family = family_map[temp]
      c_family.children.append(c_character.id)
      c_character.FAMC = c_family.id
  elif c_character.spouse != [] and cull_childless_spouses is False:
    c_character.loner = False
    if c_character.gender == 1:
      for i_spouse in c_character.spouse:
        c_spouse = character_map[i_spouse]
        if c_spouse.gender == 0:
          temp = (c_character.id, c_spouse.id)
          if temp not in family_map:
            family_list.append(family())
            c_family = family_list[-1]
            c_family.id = family_id
            c_family.father = c_character.id
            c_family.mother = c_spouse.id
            family_map[temp] = c_family
            c_character.FAMS.append(c_family.id)
            c_spouse.FAMS.append(c_family.id)
            c_spouse.loner = False
            family_id += 1
    elif c_character.gender == 0:
      for i_spouse in c_character.spouse:
        c_spouse = character_map[i_spouse]
        if c_spouse.gender == 1:
          temp = (c_spouse.id, c_character.id)
          if temp not in family_map:
            family_list.append(family())
            c_family = family_list[-1]
            c_family.id = family_id
            c_family.father = c_spouse.id
            c_family.mother = c_character.id
            family_map[temp] = c_family
            c_character.FAMS.append(c_family.id)
            c_spouse.FAMS.append(c_family.id)
            c_spouse.loner = False
            family_id += 1

## Creating the .ged File ############################################
print '### Finished processing data. Now creating .ged file. ###'
GEDCOM_map = {}
GEDCOM_id = 1
for i_character in character_map:
  c_character = character_map[i_character]
  if not cull_loners:
    c_character.GEDCOM_id = GEDCOM_id
    GEDCOM_map[GEDCOM_id] = c_character.id
    GEDCOM_id += 1
  else:
    if not c_character.loner:
      c_character.GEDCOM_id = GEDCOM_id
      GEDCOM_map[GEDCOM_id] = c_character.id
      GEDCOM_id += 1

with open(savefilename+'.ged','w') as file2:
  line = '0 HEAD\n1 FILE '+savefilename+'.ged\n1 GEDC\n2 VERS 5.5\n2 FORM LINEAGE-LINKED\n1 CHAR ANSI'
  for i_character in GEDCOM_map:
    c_character = character_map[GEDCOM_map[i_character]]
    if c_character.gender is 0:
      gender_string = 'F'
    else:
      gender_string = 'M'
    line += '\n0 @I'+str(i_character)+'@ INDI'
    line += '\n1 NAME '+c_character.birth_name+' /'+c_character.dynasty_name.upper()+'/'
    line += '\n2 GIVN '+c_character.birth_name
    line += '\n2 SURN '+c_character.dynasty_name
    line += '\n1 SEX '+gender_string
    line += '\n1 NOTE Game ID# '+str(c_character.id)
    if c_character.birth_year != []:
      temp_string = str(c_character.birth_day)+' '+month_name[c_character.birth_month-1]+' '+str(c_character.birth_year)
      line += '\n1 BIRT'
      line += '\n2 DATE '+temp_string
    if c_character.death_year != [] and c_character.death_year != 1:
      temp_string = str(c_character.death_day)+' '+month_name[c_character.death_month-1]+' '+str(c_character.death_year)
      line += '\n1 DEAT'
      line += '\n2 DATE '+temp_string
    for i_ in c_character.FAMS:
      line += '\n1 FAMS @F'+str(i_)+'@'
    if c_character.FAMC != '':
      line += '\n1 FAMC @F'+str(c_character.FAMC)+'@'
  for i_family in family_list:
    line += '\n0 @F'+str(i_family.id)+'@ FAM'
    if i_family.father != '':
      c_character = character_map[i_family.father]
      line += '\n1 HUSB @I'+str(c_character.GEDCOM_id)+'@'
    if i_family.mother != '':
      c_character = character_map[i_family.mother]
      line += '\n1 WIFE @I'+str(c_character.GEDCOM_id)+'@'
    for i_child in i_family.children:
      c_character = character_map[i_child]
      line += '\n1 CHIL @I'+str(c_character.GEDCOM_id)+'@'
  
  file2.writelines(line)
  file2.close()

## Creating .csv Files ###############################################
if create_csv:
  print '### Finished creating .ged file. Creating .csv files. ###'
if create_dynasty_csv:
  with open(savefilename+'_dynasty.csv','w') as file:
    line = 'ID#;Name'
    for i_ in dynasty_list:
      line += '\n'+str(i_.id)+';'+str(i_.name)
    
    file.writelines(line)
    file.close()
if create_character_csv:
  with open(savefilename+'_character.csv','w') as file:
    line = 'Game ID#;GEDCOM ID#;Dynasty ID#;Dynasty Name;Given Name;Gender ID#;Loner?;Birth Year;Birth Month;Birth Day;Death Year;Death Month;Death Day;Father ID#;Mother ID#;Spouse ID#s;FAMS;FAMC'
    for i_ in character_list:
      line += '\n'+str(i_.id)+';'+str(i_.GEDCOM_id)+';'+str(i_.dynasty_id)+';'+str(i_.dynasty_name)+';'+str(i_.birth_name)+';'+str(i_.gender)+';'+str(i_.loner)+';'+str(i_.birth_year)+';'+str(i_.birth_month)+';'+str(i_.birth_day)+';'+str(i_.death_year)+';'+str(i_.death_month)+';'+str(i_.death_day)+';'+str(i_.father)+';'+str(i_.mother)+';'+str(i_.spouse)+';'+str(i_.FAMS)+';'+str(i_.FAMC)
    
    file.writelines(line)
    file.close()
if create_family_csv:
  with open(savefilename+'_family.csv','w') as file:
    line = 'ID#;Father ID#;Mother ID#;Children ID#s'
    for i_ in family_list:
      line += '\n'+str(i_.id)+';'+str(i_.father)+';'+str(i_.mother)+';'+str(i_.children)
    
    file.writelines(line)
    file.close()

## Finalize ##########################################################
if create_csv:
  print '### Finished creating .csv files. Stopping program. ###'
else:
  print '### Finished creating .ged file. Stopping program. ###'
print 'Processed',str(len(dynasty_list)),'dynasties.'
print 'Processed',str(len(character_list)),'characters.'
print 'Processed',str(len(family_list)),'families.'

"""
Authored by Leyic
2012.02.18: Support for childless spouses. Fix for parentless parents.
            Implemented .csv output for dynasties, characters, and families.
2012.02.17: Clean up and organization.
            Implemented 'state_change' function.
            Reports number of dynasties, characters, and families processed.
2012.02.16: Finished processing and GEDCOM sections. Initial release.
2012.02.15: Initial version. Finished file reading sections. Started processing section.
            Based on sengoku2gedcom.py (2011.09.21-2011.09.26)
"""
